--===============================================================================================
--      Conditionally DROP and CREATE the MinLogTest database.
--      ***** LOOK FOR TODO BEFORE RUNNING THIS SCRIPT!!! *****
--       Copyright - Jeff Moden, 18 August 2023, All Rights Reserved
--===============================================================================================
--===== Notify the operator.
        RAISERROR('Dropping the MinLogTest database if it exists.',0,0) WITH NOWAIT
;
--===== Make sure we're not currently running in the database we're getting ready to drop.
    USE master
;
--===== If it exists, drop the MinLogTest and any backup history it may have previously spawned.
     IF DB_ID(N'MinLogTest') IS NOT NULL
  BEGIN
           EXEC msdb.dbo.sp_delete_database_backuphistory @database_name = N'MinLogTest';
          ALTER DATABASE [MinLogTest] SET SINGLE_USER WITH ROLLBACK IMMEDIATE;
           DROP DATABASE [MinLogTest];
    END
;
--===== Notify the operator.
        RAISERROR('Creating the MinLogTest database.',0,0) WITH NOWAIT
;
--===== Create the database.
     -- The reason why we don't just create a database using the defaults is because the defaults
     -- for the system may be too large for this demonstration when it comes to "Minimal Logging".
 CREATE DATABASE [MinLogTest] ON PRIMARY 
        (--TODO: Change the file path to suit your system.
         NAME       = N'MinLogTest'
        ,FILENAME   = N'E:\SQLServer2022\SQLData\MinLogTest.mdf'  
        ,SIZE       = 50MB 
        ,FILEGROWTH = 50MB
        )
        LOG ON 
        (--TODO: Change the file path to suit your system.
         NAME       = N'MinLogTest_log'
        ,FILENAME   = N'E:\SQLServer2022\SQLLog\MinLogTest_log.ldf'
        ,SIZE       = 50MB
        ,FILEGROWTH = 50MB
        )
;
--===== Make sure the database is in the SIMPLE Recovery Model to ensure that we'll be using 
     -- "Minimal Logging" for our purposes. 
  ALTER DATABASE [MinLogTest] SET RECOVERY SIMPLE
; 
GO
--=====================================================================================================================
--      Create the dbo.fnTally function.
--=====================================================================================================================
--===== Notify the operator.
        RAISERROR('Creating the dbo.fnTally function.',0,0) WITH NOWAIT
;
--===== Use the database we just created.
    USE MinLogTest
;
GO
 CREATE FUNCTION dbo.fnTally
/**********************************************************************************************************************
 Purpose:
 Given a starting value of "0" or "1" and a max positive value <= 2,147,483,647, return the range of whole numbers
 from the start value to the max value.

 This is just one version of the "dbo.fnTally" function. This one is based on 16 original values. It has exactly the
 same functionality as other versions.  It's been called dbo.fnTally16 so as not to take a chance on overwriting what
 someone is currently using but can easily withstand being renamed to suit.  This flower box is also a lot shorter. 
-----------------------------------------------------------------------------------------------------------------------
 Usage:
--===== Basic syntax example
 SELECT N FROM dbo.fnTally(@ZeroOrOne,@MaxN);

--===== Return values from 0 to 1000
 SELECT N FROM dbo.fnTally(0,1000);

--===== Return values from 1 to 1000
 SELECT N FROM dbo.fnTally(1,1000);
-----------------------------------------------------------------------------------------------------------------------
 1. This code works for SQL Server 2008 and up.
 2. Based on Itzik Ben-Gan's cascading CTE (cCTE) method for creating a "readless" Tally Table source of BIGINTs.
    Refer to the following URL for how it works.
    https://www.itprotoday.com/sql-server/virtual-auxiliary-table-numbers
 3. This code only uses 7 "Nested Loops" instead of 31
-----------------------------------------------------------------------------------------------------------------------
 Revision History:
 Rev 00 - Unknown     - Jeff Moden 
        - Initial creation with error handling for @MaxN.
 Rev 01 - 09 Feb 2013 - Jeff Moden 
        - Modified to start at 0 or 1 and removed error handling for @MaxN.
**********************************************************************************************************************/
        (@ZeroOrOne TINYINT, @MaxN BIGINT)
RETURNS TABLE WITH SCHEMABINDING AS 
 RETURN WITH
   E1(N) AS (SELECT 1 FROM (VALUES (1),(1),(1),(1),(1),(1),(1),(1),(1),(1),(1),(1),(1),(1),(1),(1))E0(N))
             SELECT N = 0 WHERE @ZeroOrOne = 0 UNION ALL   --May or may not be present as a row in the return
             SELECT TOP(@MaxN)
                    N = ROW_NUMBER() OVER (ORDER BY (SELECT NULL))
               FROM E1 a,E1 b,E1 c,E1 d,E1 e,E1 f,E1 g,E1 h         --1 to 16^8 or 4,294,967,296 rows max
              ORDER BY N
;
GO
--===== Notify the operator.
        RAISERROR('RUN COMPLETE',0,0) WITH NOWAIT
;